{smcl}
{* *! version 1.0.0 5aug2014}{...}
{title:Title}

{phang}
{bf:dsimih} {hline 2} Create and analyze structural IRFs and FEVDs after {help svarih}


{marker syntax}{...}
{title:Syntax}

{p 8 12 2}
{cmd:dsimih} {it:subcommand ...} [{cmd:,} {it:...}]

{synoptset 15}{...}
{synopthdr:subcommand}
{synoptline}
{synopt:subcommands I}{p_end}
{synopt:{helpb dsimih_create:create}}create SIRFs and SFEVDs{p_end}

{synopt:subcommands II}{p_end}
{synopt:{helpb dsimih_table:table}}create tables of results{p_end}
{synopt:{helpb dsimih_graph:graph}}graph results{p_end}

{synopt:subcommands III}{p_end}
{synopt:{helpb dsimih_describe:describe}}describe forecast horizons of dynamic simulation statistics{p_end}
{synopt:{helpb dsimih_use:use}}load dynamic simulation statistics into data set memory{p_end}
{synopt:{helpb dsimih_drop:drop}}remove dynamic simulation statistics{p_end}
{synopt:{helpb dsimih_etodta:etodta}}save results in {cmd:e()} as a {cmd:dsimih file}{p_end}
{synoptline}
{p2colreset}{...}


{marker description}{...}
{title:Description}

{pstd}
{opt dsimih} and its subcommands create and manipulate dynamic simulation results that are based on estimates of {help svarih}.
These results are either stored in matrices in {cmd:e()} along with the estimation results or they are pulled from an external Stata data set file.
The matrices or the data set contain estimates of the conditional structural impulse-response functions (SIRFs) and structural forecast-error variance decompositions (SFEVDs).
"Conditional" means that the SIRFs and SFEVDs are to be interpreted as dynamic simulation results that obtain within one specific regime.


{marker abbreviations}{...}
{title:Abbreviations, definitions, syntax elements}

{pstd}
This help entry and the help entries of {cmd:dsimih} subcommands use abbreviations and definitions from {help svarih##abbreviations:svarih}.
In addition, this help entry and the help entries of {cmd:dsimih} subcommands use the following abbreviations and definitions:

{p2colset 5 36 36 0}{...}
{p2col:Abbreviations:}{p_end}
{p2col:DS}dynamic simulation{p_end}
{p2col:}{p_end}
{p2col:Syntax elements:}{p_end}
{p2col:{it:stat}}{cmd:dsimih} {it:stat}s are {opt si:rf} and {opt sf:evd}{p_end}
{p2col:{it:setype}}the type of standard error. One of {opt a:symptotic}, {opt bs} and {opt bsp}.{p_end}
{p2col:}{p_end}

{marker remarks}{...}
{title:Remarks}

{pstd}
Remarks are presented under the following headings:

    {help dsimih##thedsimihsystem:The dsimih system}
    {help dsimih##differencestoirf:Differences to irf}
    {help dsimih##storing:Storing results in and retrieving results from Stata data files}

{marker thedsimihsystem}{...}
{title:The dsimih system}

{pstd}
If you want to create, analyze and manage DS results after {cmd:svarih}, you start out by generating results using {cmd:dsimih create}.
Once you have obtained the statistics you are looking for, you can analyze them using subcommands II.
Subcommands III are tools for the data management of different results sets.


{marker differencestoirf}{...}
{title:Differences to irf}

{pstd}
{opt dsimih} in many ways resembles official Stata's {help irf} but deviates in some respects.
What {cmd:irf} and {cmd:dsimih} share in common is a three-step approach:
You first generate estimation results using {cmd:svarih} ({cmd:var}/{cmd:svar}/{cmd:vec} for {cmd:irf}).
Then you generate DS results using {cmd:dsimih create} ({cmd:irf create} for the {cmd:irf} system).
Then you display and analyze results using {cmd:dsimih table} and {cmd:dsimih graph} (the {cmd:irf} system has five such subcommands).
Moreover, the subcommands of {cmd:dsimih} that manage DS results are similar to the ones of {cmd:irf}.

{pstd}
The main differences are:

{p2colset 8 10 10 2}{...}
{p2col:-}{cmd:irf} handles many different types of statistics.
         {cmd:dsimih} is only concerned with SIRFs and SFEVDs.{p_end}
{p2col:-}{cmd:dsimih} has some additional options to account for the specifics of the IH model setup.{p_end}
{p2col:-}{cmd:irf create} always stores DS results in a separate Stata file.
{cmd:dsimih create}, by contrast, defaults to storing its DS results in {cmd:e()}, among the results from {cmd:svarih} estimation.
It does, however, have options to store results in and retrieve results from Stata data files.
This is mainly thought for Stata/IC users whose maximum {help matsize} setting is 800 (see {help limits}), which constitutes a serious constraint for storing DS results sets in {cmd:e()}.
The fact that the default storage location of results is {cmd:e()} has several implications:{p_end}
{p2colset 10 12 12 2}{...}
{p2col:>}You can save results in between sessions in {opt .ster} files using {help estimates save}.
         However, after you create results using {cmd:dsimih create} you must explicitly (re-)save the {opt .ster} file, otherwise you will lose results when results in {cmd:e()} are cleared or replaced.{p_end}
{p2col:>}The benefit of this approach is that {cmd:svarih} estimation results and DS results are always stored together.
         It is not possible to erroneously assign a set of DS results to the wrong estimation results.
         Data management work is easier in some respects.{p_end}
{p2col:>}The structure of saved results is different.
         With {cmd:irf}, you have a different {it:irfname} results sets for e.g. different types of standard errors.
         With {cmd:dsimih}, different types of standard errors are stored in the same results set, in {cmd:e()}.
         Let's assume that you want to further differentiate results, say, you want to create results for a parametric bootstrap with 200 replications as well as results for 500 replications.
         In this case you have to save one of the results sets either within a different {opt .ster} file or in the same {opt .ster} file, but under a different estimation results number. See {help estimates save}.{p_end}
{p2col:>}{cmd:irf} results sets have a variable "irfname", {cmd:dsimih} results sets do not.
         Conversely, {cmd:dsimih} results sets have an additional variable "regime" since DS results are different for each regime.{p_end}
{p2colset 8 10 10 2}{...}
{p2col:-}There are a number of smaller differences.
         For example, {cmd:dsimih} may give you easier access to data graphed and tabulated than {cmd:irf}.
         As another example, the graphics capabilities of {cmd:irf} are a good bit more sophisticated than those of {cmd:dsimih}.
         You will encounter more of such smaller differences as you read through the {cmd:dsimih} subcommand help files.{p_end}
{p2colreset}{...}

{pstd}
Despite this list of differences, the commonalities are substantial.
If you are already familiar with the {cmd:irf} system, learning to use the {cmd:dsimih} system should be easy.

{marker storing}{...}
{title:Storing results in and retrieving results from Stata data files}

{pstd}
{cmd:dsimih}'s default method of storing DS results is to place them among the {cmd:e()} results of {cmd:svarih}.
Nevertheless, the {cmd:dsimih} system provides a fully functional alternative: You can save results in and retrieve results from Stata data files.
See {help dsimih_etodta##dsimihfiles:dsimih etodta} for details on the structure of these files.

{p2colset 5 7 7 0}{...}
{p2col:This approach is thought for the following situations:}{p_end}
{p2col:-}The DS results are large and cannot be accommodated by your maximum {help matsize} setting.
This is less relevant for {help SpecialEdition:Stata/SE} and {help statamp:Stata/MP} users, since DS results rarely go beyond the maximum {cmd:matsize} setting of 11,000.
However, the {help stataic:Stata/IC} limit is 800.
Here it is more likely that your DS results become too large to be stored in {cmd:e()}.{p_end}
{p2col:-}You may be accustomed to managing DS results within files from your prior experience with {cmd:irf} and you want to manage your {cmd:dsimih} results in a similar fashion.{p_end}
{p2col:-}You work in multiple versions of Stata, or you want to share your results with somebody else who works in a different version of Stata.
The problem is that you may not be able to load a {opt .ster} file in a Stata version that is lower than the one that saved the {opt .ster} file.
In these cases, you can export the {cmd:dsimih} results to a Stata data file and re-save this file using the {cmd:saveold} command, if necessary, to make it accessible to previous versions of Stata.{p_end}
{p2colreset}{...}

{phang}
{bf:Storing results in Stata data files:} You can store DS results in Stata data files directly from {cmd:dsimih create} using its {opt saving()} option.
You must use this option if the DS results cannot be accommodated by your maximum {cmd:matsize} setting.
{cmd:svarih create} will prompt you to use this option if it is necessary.
Note that these files only contain data points for at most one type of standard error (the one specified in your {cmd:dsimih create} statement).

{pmore}
If you have stored DS results in {cmd:e()}, you can save them as a Stata data set file using {cmd:dsimih etodta}.
This data set will be identical to the results stored in {cmd:e()} and hence can contain data for different types of standard errors.

{phang}
{bf:Retrieving results from Stata data files:} All {cmd:dsimih} subcommands have a {opt using} modifier which lets you access {cmd:dsimih files} instead of results stored in {cmd:e()}.

{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker acknowledgements}{...}
{title:Acknowledgements}

{pstd}
The code from official Stata's {help irf} and {help irf create} has served as a point of reference throughout the development of {cmd:dsimih} and {cmd:dsimih create}.
Many features of the {cmd:irf} system have been incorporated into the {cmd:dsimih} system.
Snippets of text from official Stata's help files have been re-used.
Any remaining errors in the {cmd:dsimih} system are mine.


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb irf:[TS] irf},
{helpb dsimih create},
{helpb dsimih table},
{helpb dsimih graph},
{helpb dsimih describe},
{helpb dsimih use},
{helpb dsimih drop},
{helpb dsimih etodta}
{p_end}

